/*
 * Copyright (c) 2019-2021 Amazon.com, Inc. or its affiliates.  All rights
 * reserved.
 * Portions Copyright (C) 2018 Sigmastar Technology Corp
 *
 * This software is licensed under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation, and
 * may be copied, distributed, and modified under those terms.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef INCLUDED_AMAZON_NET_H_
#define INCLUDED_AMAZON_NET_H_

#include <linux/netdevice.h>
#include <linux/mmc/sdio_func.h>

struct amazon_net_ops {
	int (*xmit)(struct net_device *ndev, struct sk_buff *skb);

	int (*init)(void);
	void (*deinit)(void);

	u16 (*select_queue)(struct net_device *dev,
			    struct sk_buff *skb,
			    struct net_device *sb_dev,
			    select_queue_fallback_t fallback);
	int (*do_ioctl)(struct net_device *dev,
			struct ifreq *ifreq,
			int cmd);
	void (*flush_channel)(struct net_device *dev,
			      uint8_t channel);
};

struct amazon_net_priv {
	struct net_device *ndev;
	const struct amazon_net_ops *ops;
};

#define DRV_NAME	"amazon_net"
#define DRV_VERSION	"1.0"

#define RED_SDIO_NETIF_CH (30)

struct net_device  *amazon_net_ndev_alloc(int sizeof_priv,
					   const char *name_pattern, bool ip);
void amazon_net_ndev_free(struct net_device *ndev);

int amazon_net_ndev_register(struct net_device *ndev,
			      const struct amazon_net_ops *ops);
void amazon_net_ndev_unregister(struct net_device  *ndev);

struct net_device  *amazon_net_ndev_create(int sizeof_priv,
					   const struct amazon_net_ops *ops,
					   const char *name_pattern);
void amazon_net_ndev_delete(struct net_device  *ndev);
int amazon_net_receive(struct net_device *ndev, struct sk_buff *skb, bool ip);
int escape_string_buffer(char *buff,
			 unsigned int maxlen,
			 const unsigned char *data,
			 unsigned int len);
void *amazon_net_ndev_priv(const struct net_device *ndev);

extern const struct amazon_net_ops amazon_sdio_ops;
extern const struct amazon_net_ops loop_ops;

// This is appended to the start of data sent/received
struct mt7682_protocol_header {
	u8 channel;
	u16 size;
	u8 spare;
} __packed;

// Format of internal command data
struct amazon_internal_command {
	u8 cmd;
	u8 len;
	u32 payload;
} __packed;

#endif // ifdef INCLUDED_AMAZON_NET_H_
